/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.com/copyright-license

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

/*DRAWBUFFERS:312*/
layout(location = 0) out vec4 sceneColor;
layout(location = 1) out vec4 sceneData0;
layout(location = 2) out vec4 sceneData1;

#include "/lib/head.glsl"
#include "/lib/util/colorspace.glsl"
#include "/lib/util/encoders.glsl"

const int shadowMapResolution   = 2560;     //[512 1024 1536 2048 4560 3072 3584 4096 6144 8192 16384]

in mat2x2 coord;

in float warp;

in vec3 shadowmapPos;
in vec3 worldPos;

in vec4 tint;

flat in int matID;

flat in vec3 normal;

flat in mat3x3 lightColor;

#ifdef gTERRAIN
    in float viewDist;
    flat in mat3 tbn;
    in vec3 tangentViewDir;

    in vec2 vCoord;
    in vec4 vCoordAM;
#endif

uniform sampler2D gcolor;

uniform sampler2D noisetex;

uniform int frameCounter;

uniform float frameTimeCounter;
uniform float lightFlip;
uniform float sunAngle;

uniform vec3 lightvec, lightvecView;

uniform sampler2DShadow shadowtex0;
uniform sampler2DShadow shadowtex1;
uniform sampler2D shadowcolor0;


/* ------ includes ------ */
#define FUTIL_LIGHTMAP
#include "/lib/fUtil.glsl"

#include "/lib/frag/bluenoise.glsl"

#include "/lib/light/diffuse.glsl"
#include "/lib/light/shadow2D.glsl"


float bayer2e(vec2 a){
    a = floor(a);
    return fract( dot(a, vec2(.5, a.y * .75)) );
}
#define bayer4e(a)   (bayer2e( .5*(a))*.25+bayer2e(a))

#define m vec3(31,63,31)
float encode3x8(vec3 a){
    float dither = bayer4e(gl_FragCoord.xy);
    a += (dither-.5) / m;
    a = saturate(a);
    ivec3 b = ivec3(a*m);
    return float( b.r|(b.g<<5)|(b.b<<11) ) / 65535.;
}
#undef m

#ifdef gTERRAIN

#include "/lib/util/bicubic.glsl"

#include "/lib/atmos/waterWaves.glsl"

#define waterParallaxDepth 3.0  //[0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0 2.25 2.5 2.75 3.0 3.25 3.5 3.75 4.0]

vec3 waterParallax(vec3 pos, vec3 dir) {    //based on spectrum by zombye
    const uint steps    = 8;

    vec3 interval   = inversesqrt(float(steps)) * dir / -dir.y;
    float height    = waterWaves(pos) * waterParallaxDepth;
    float stepSize  = height;
        pos.xz     += stepSize * interval.xz;

    float offset    = stepSize * interval.y;
        height      = waterWaves(pos) * waterParallaxDepth;

    for (uint i = 1; i < steps - 1 && height < offset; ++i) {
        stepSize    = offset - height;
        pos.xz     += stepSize * interval.xz;

        offset     += stepSize * interval.y;
        height      = waterWaves(pos) * waterParallaxDepth;
    }

    if (height < offset) {
        stepSize    = offset - height;
        pos.xz     += stepSize * interval.xz;
    }

    return pos;
}

vec3 waterNormal(inout vec2 textureDelta) {
    vec3 pos    = worldPos;
    #ifdef waterParallaxEnabled
        pos    = waterParallax(worldPos, tangentViewDir.xzy);
    #endif

    float dstep   = 0.005 + (1.0 - exp(-viewDist * rcp(32.0))) * 0.035;

    vec2 delta;
        delta.x     = waterWaves(pos + vec3( dstep, 0.0, -dstep));
        delta.y     = waterWaves(pos + vec3(-dstep, 0.0,  dstep));
        delta      -= waterWaves(pos + vec3(-dstep, 0.0, -dstep));

        textureDelta = (delta.xy / 0.04);

    return normalize(vec3(-delta.x, 2.0 * dstep, -delta.y));
}

#endif

void main() {
        sceneColor   = texture(gcolor, coord[0]);
    if (sceneColor.a<0.02) discard;
        sceneColor.rgb *= tint.rgb;

    vec3 sceneNormal = normal;

    convertToPipelineAlbedo(sceneColor.rgb);

    vec3 hue    = normalize(sceneColor.rgb);

    #ifdef gTERRAIN
        if (matID == 102 || matID == 103) {
            vec2 texDelta = vec2(0.0);
            sceneNormal = waterNormal(texDelta);

            texDelta    = (vCoord + texDelta);

            vec2 dx     = dFdx(coord[0]);
            vec2 dy     = dFdy(coord[0]);
                
            sceneColor        = textureGrad(gcolor, fract(texDelta)*vCoordAM.zw+vCoordAM.xy, dx, dy);
            sceneColor.rgb    = linearToAP1(toLinear(sceneColor.rgb * tint.rgb));

            if (matID == 102) {
            #ifdef overrideWaterTexture
                float textureAlpha = cube(sceneColor.a);
                sceneColor.rgb = vec3(waterColorRed, waterColorGreen, waterColorBlue)*(0.15 + textureAlpha * waterTextureBlend);
                sceneColor.a   = waterColorAlpha;
            #endif
                hue      = vec3(1.0);
            } else {
                sceneColor.a   *= sqrt(sceneColor.a);
                sceneColor.rgb *= 0.5;
            }
        }
    #endif

    vec2 lmap       = coord[1];
    float ao        = tint.a;

    lmap.y          = cube(lmap.y);

    float diff      = diffuseLambert(normal, lightvec);

    shadowData shadow   = getShadowRegular(diff>0.0);

    float diffLit       = min(diff, shadow.shadow);

    vec3 directCol      = lightColor[0] ;
    vec3 directLight    = diffLit * shadow.color * directCol;

    vec3 indirectLight  = lmap.y*lightColor[1];
        indirectLight  += vec3(0.5, 0.7, 1.0) * (0.01 * minLightLuma);
        indirectLight  *= ao;

    vec3 result     = directLight + indirectLight;
        result     += getBlocklightMap(lightColor[2], lmap.x)*ao;

    sceneColor  = makeDrawbuffer(sceneColor.rgb, saturate(sceneColor.a));
    sceneData0  = vec4(encodeNormal(sceneNormal), encode2x8(coord[1]), 1.0);
    sceneData1  = vec4(encodeMatID16(matID), encode2x8(vec2(0.0, 0.02)), encode3x8(hue), 1.0);
}